function run_job(dir,run_opt,rounds)

% some overhead, making sure that cache files are deleted
if ~exist(dir,'dir'), mkdir(dir), end;
evalfile = sprintf('%s/%s-evaluation.mat',dir,get_run_opt_FN(run_opt));
if exist(evalfile), delete(evalfile), end;

N = run_opt.data_opt.N;
for r = 1:rounds
    fprintf('\n\nRunning round %i ... \n',r);
    load(sprintf('%s/%s-r=%i-data.mat',dir,run_opt.data_opt.name,r),'A','U','X','candU','candX','XN');

    % estimate sigma from XN or use it as given
    if 0 < run_opt.sigma_method && run_opt.sigma_method < 1
        sigma_noise = run_opt.sigma_method;
        fprintf('Sigma directly given: sigma = %g\n',sigma_noise);
    else
        switch run_opt.sigma_method
            case -1 % known (not necessarily true for SDE simluation)
                sigma_noise = run_opt.data_opt.sigma_noise;
            case 1
                sigma_noise = std(XN(:));
            case 2
                sigma_noise = mean(std(XN,0,2) ./ abs(diag(A)));
            case 3 % old and working
                sigma_noise = std(XN(:)) ./ mean(abs(diag(A)));
            case 4
                x = log10(run_opt.data_opt.input_scale);
                y = -9 +  7/4* (x+4);
                sigma_noise = 10^(y);
            case 5
                ee = A * [X,candX] - [U,candU];
                sigma_noise = std(ee(:));
            otherwise
                error('Unkown method to determine Sigma.');
        end
        fprintf('Sigma method %i: sigma = %g\n',run_opt.sigma_method,sigma_noise);
    end

    % estimate tau or sigma respectively
    GG = (A > run_opt.eps) | (A < -run_opt.eps);
    deg = mean(sum(GG,2));
    switch run_opt.method
        case {1,3}
            if run_opt.tau ~= -1
                tau_est = run_opt.tau;
            else
                tau_est = -1/run_opt.eps * log(deg/N);
                fprintf('Estimated Laplace sigma: %g (tau = %g)\n',sqrt(2)/tau_est,tau_est);
            end
        case {4,5}
            if run_opt.tau ~= -1
                sigma_model = 1/run_opt.tau;
            else
                opt = optimset('largescale','off','Display','off');
                sigma_model = fminunc(@(x)((1-mycdf(0,x,run_opt.eps)+mycdf(0,x,-run_opt.eps)-deg/N)^2),1,opt);
                fprintf('Estimated Gaussian sigma: %g\n',sigma_model);
            end
    end

    tic
    switch run_opt.method
        case 1
            [Qm,Qv,times,order] = Laplace_Design(U,X,candU,candX,sigma_noise,tau_est,run_opt.num_inclus,run_opt.initial_rand);
        case 3
            [Qm,Qv,times,order] = Laplace_Random(U,X,candU,candX,sigma_noise,tau_est,run_opt.num_inclus);
        case 4
            [Qm,Qv,times,order] = Gauss_Design(U,X,candU,candX,sigma_noise,sigma_model,run_opt.num_inclus,run_opt.initial_rand);
        case 5
            [Qm,Qv,times,order] = Gauss_Random(U,X,candU,candX,sigma_noise,sigma_model,run_opt.num_inclus);
        otherwise
            error('Unkown method');
    end
    times = toc;
    fprintf('Used %g sec for computing experiment.\n',times);

    round_fn = sprintf('%s/%s-r=%i-results.mat',dir,get_run_opt_FN(run_opt),r);
    save(round_fn, 'Qm','Qv','times','order');
    clear Qm Qv times order U X candU candX
end


function [Qm,Qv,times,order] = Laplace_Design(U,X,candU,candX,sigma_noise,tau,num_inclus,num_initial_rand)
orderfunction = @(i,X,U,sitepi,siteb,L,gamma,candU,sigma_noise,order)...
    (Select_Designed_Experiment(i,X,U,sitepi,siteb,L,gamma,candU,sigma_noise,order,num_initial_rand));
[Qm,Qv,times,order] = Laplace_Inference(U,X,candU,candX,sigma_noise,tau,num_inclus,orderfunction);
    
function [Qm,Qv,times,order] = Laplace_Random(U,X,candU,candX,sigma_noise,tau,num_inclus)
[Qm,Qv,times,order] = Laplace_Inference(U,X,candU,candX,sigma_noise,tau,num_inclus,@Select_Random_Experiment);

function [Qm,Qv,times,order] = Gauss_Design(U,X,candU,candX,sigma_noise,sigma_model,num_inclus,num_initial_rand)
orderfunction = @(i,X,U,sitepi,siteb,L,gamma,candU,sigma_noise,order)...
    (Select_Designed_Experiment(i,X,U,sitepi,siteb,L,gamma,candU,sigma_noise,order,num_initial_rand));
[Qm,Qv,times,order] = Gauss_Inference(U,X,candU,candX,sigma_noise,sigma_model,num_inclus,orderfunction);
    
function [Qm,Qv,times,order] = Gauss_Random(U,X,candU,candX,sigma_noise,sigma_model,num_inclus)
[Qm,Qv,times,order] = Gauss_Inference(U,X,candU,candX,sigma_noise,sigma_model,num_inclus,@Select_Random_Experiment);


function ind = Select_Random_Experiment(i,X,U,sitepi,siteb,L,gamma,candU,sigma_noise,order)
m = size(candU,2);n = size(candU,1);
% find all that candU that are not used yet
poss = true(m,1);
poss(order(1:i-1)) = false;
poss = find(poss);
% choose a random one
ind = irand(1,1,length(poss));
ind = poss(ind);

function ind = Select_Designed_Experiment(i,X,U,sitepi,siteb,L,gamma,candU,sigma_noise,order,num_initial_rand)
if i <= num_initial_rand
    ind = Select_Random_Experiment(i,X,U,sitepi,siteb,L,gamma,candU,sigma_noise,order);
else
    n = size(X,1);
    % find all that candU that are not used yet
    poss = true(size(candU,2),1);
    poss(order(1:i-1)) = false;
    poss = find(poss);
    poss_candU = candU(:,poss);
    
    
    X = X';
    U = U';
    scores = zeros(size(poss_candU,2),1);
    num_Asamples = 20;
    for i = 1:num_Asamples
        % sample x_cand matix A from posterior
        temp_candX = eplin_sampxcand(X,U,sigma_noise^2,1,sitepi,siteb,L,gamma,poss_candU);
        
        % compute score for 
        for j = 1:n
            scores = scores + eplin_compscores(X,U(:,j),sigma_noise^2,1,...
                sitepi{j},siteb{j},L{j},gamma{j},temp_candX,poss_candU(j,:)');
        end
    end
    scores = scores / n / num_Asamples;
    [void,ind] = max(scores);
    ind = poss(ind);
    fprintf('Selected candidate %i with score %g.\n',ind,void);
end
  


function [Qm,Qv,times,order] = Laplace_Inference(U,X,candU,candX,sigma_noise,tau,num_inclus,orderfunction)
n = size(X,1);

% initialise n sparse linear models
sitepi = cell(n,1);
siteb = cell(n,1);
L = cell(n,1);
gamma = cell(n,1);
for i = 1:n
    sitepi{i} = repmat(0.5*(tau*sigma_noise)^2,n,1);
    siteb{i} = zeros(n,1);
    L{i} = zeros(n);
    gamma{i} = zeros(n,1);
end
pithres = 1e-16;
wkvec1 = zeros(n,1);wkvec2 = zeros(n,1);wkvec3 = zeros(n,1);
Qm = cell(num_inclus+1,1);
Qv = cell(num_inclus+1,1);

% do the initial updates
fprintf('Initialisation ...\n');
for i = 1:n
    for j = 1:20
        sweep_ord = randperm(n);
        delta=ep_splinsweep(X',U(i,:),sigma_noise^2,tau*sigma_noise,...
            sitepi{i},siteb{i},sweep_ord,L{i},gamma{i},pithres,...
            double(j==1),wkvec1,wkvec2,wkvec3,0,1,0.5);
        %         For checking whether the algotithm converges
        %         fprintf(1,'i = %i j = %i delta=%f\n',i,j,delta);
    end
end
[Qm{1},Qv{1}] = eval_marginal_mean_var(L,gamma,sigma_noise);

% now iterate over experiments
order = zeros(num_inclus,1);
for m = 1:num_inclus
    fprintf('Performing %i-th measurement (Design + Update) ...\n',m);
    order(m) = orderfunction(m,X,U,sitepi,siteb,L,gamma,candU,sigma_noise,order);

    X = [X,candX(:,order(m))];
    U = [U,candU(:,order(m))];
    for i = 1:n
        for j = 1:10
            sweep_ord = randperm(n);
            delta=ep_splinsweep(X',U(i,:),sigma_noise^2,tau*sigma_noise,...
                sitepi{i},siteb{i},sweep_ord,L{i},gamma{i},pithres,...
                double(j==1),wkvec1,wkvec2,wkvec3,0,1,0.5);
            %         For checking whether the algotithm converges
            %         fprintf(1,'i = %i j = %i delta=%f\n',i,j,delta);
        end
    end
    [Qm{m+1},Qv{m+1}] = eval_marginal_mean_var(L,gamma,sigma_noise);
end
times = 0;

function [Qm,Qv,times,order] = Gauss_Inference(U,X,candU,candX,sigma_noise,sigma_model,num_inclus,orderfunction)
n = size(X,1);

% initialise n sparse linear models
sitepi = cell(n,1);
siteb = cell(n,1);
L = cell(n,1);
gamma = cell(n,1);
for i = 1:n
    sitepi{i} = repmat((sigma_noise/sigma_model)^2,n,1);
    siteb{i} = zeros(n,1);
    L{i} = zeros(n);
    gamma{i} = zeros(n,1);
end
Qm = cell(num_inclus+1,1);
Qv = cell(num_inclus+1,1);

% do the initial updates
fprintf('Initialisation ...\n');
for i = 1:n
    L{i} = chol(X*X' + diag(sitepi{i}))';
    gamma{i} = L{i} \ (X*U(i,:)');
end
[Qm{1},Qv{1}] = eval_marginal_mean_var(L,gamma,sigma_noise);

% now iterate over experiments
order = zeros(num_inclus,1);
for m = 1:num_inclus
    fprintf('Performing %i-th measurement (Design + Update) ...\n',m);
    order(m) = orderfunction(m,X,U,sitepi,siteb,L,gamma,candU,sigma_noise,order);

    X = [X,candX(:,order(m))];
    U = [U,candU(:,order(m))];
    for i = 1:n
        L{i} = chol(X*X' + diag(sitepi{i}))';
        gamma{i} = L{i} \ (X*U(i,:)');
    end
    [Qm{m+1},Qv{m+1}] = eval_marginal_mean_var(L,gamma,sigma_noise);
end
times = 0;

function [Qm,Qv] = eval_marginal_mean_var(L,gamma,sigma_noise)
n = length(L);
Qm = zeros(n);
Qv = zeros(n);
for i = 1:n
    Qm(i,:) = (L{i}'\gamma{i})';
    Qv(i,:) = diag(L{i}'\(L{i}\eye(n))*sigma_noise^2)';
end


function res = irand(n,min,max)
res = floor((rand(n,1)-1e-10)*(max-min)) + min;